<?php

namespace Drupal\field_style\Utils;

/**
 *
 */
class GoogleFonts {

  private $google_fonts = [];
  private $url = '';
  private $style = '';

  /**
   *
   */
  public function __construct() {
    $config = \Drupal::config('field_style.settings');
    $this->google_fonts = $config->get('google_font_family') ?? [];
  }

  /**
   *
   */
  public function build($fonts_used = []) {
    $family_urls = [];

    foreach ($this->google_fonts as $font) {
      if (preg_match('/[?&]family=([^:&]+)/', $font['name'], $matches)) {
        if (in_array($matches[1], array_keys($fonts_used))) {
          $family_urls[$matches[1]] = $font['name'];
        }
      }
    }

    return $family_urls;
  }

}
