<?php

namespace Drupal\field_style\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form to manage properties for the field_style module.
 */
class FieldStyleSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['field_style.global_settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'field_style_settings_form';
  }

  /**
   * Builds the form.
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('field_style.global_settings');

    $active_properties = $config->get('properties');
    $active_states = $config->get('states');

    $form['#attached'] = [
      'library' => [
        'field_style/field_style.form_settings',
      ],
    ];

    // Define all properties.
    $properties = [
      "fontFamily", "fontSize", "fontWeight", "fontStyle",
      "textAlign", "textDecoration", "letterSpacing", "lineHeight", "textIndent",
      "textTransform", "textAlignLast", "width", "height", "margin", "marginTop",
      "marginLeft", "marginRight", "marginBottom", "padding", "paddingTop",
      "paddingLeft", "paddingRight", "paddingBottom", "color", "fill",
      "backgroundRepeat", "backgroundRepeatX", "backgroundRepeatY", "backgroundPosition",
      "backgroundImage", "backgroundPositionX", "backgroundPositionY", "backgroundSize",
      "backgroundColor", "borderRadius", "border", "borderStyle", "borderWidth",
      "borderTop", "borderLeft", "borderRight", "borderBottom", "borderColor",
      "borderTopColor", "borderTopWidth", "borderTopStyle", "borderLeftColor",
      "borderLeftWidth", "borderLeftStyle", "borderRightColor", "borderRightWidth",
      "borderRightStyle", "borderBottomColor", "borderBottomWidth", "borderBottomStyle",
      "alignContent", "alignItems", "alignSelf", "bottom", "display", "float",
      "left", "right", "maxHeight", "maxWidth", "minHeight", "top", "order", "position",
      "verticalAlign", "visibility", "whiteSpace", "wordBreak", "wordSpacing",
      "wordWrap", "zIndex", "cursor", "animation", "animationDelay", "animationDirection",
      "animationFillMode", "animationInterationCount", "animationName", "animationPlayState",
      "animationTimingFunction", "backfaceVisibility", "background", "backgroundAttachment",
      "backgroundClip", "backgroundOrigin", "boxShadow", "boxSizing", "flexDirection",
      "flexWrap", "justifyContent", "overflow", "overflowX", "overflowY",
      "textShadow", "transition", "transitionTimingFunction",
    ];

    // Properties accordion.
    $form['properties'] = [
      '#type' => 'details',
      '#title' => $this->t('Properties'),
      '#open' => TRUE,
      '#tree' => TRUE,
    ];

    foreach ($properties as $property) {
      $form['properties'][$property] = [
        '#type' => 'checkbox',
        '#title' => $this->t(ucfirst($property)),
        '#default_value' => $active_properties[$property] ?? 0,
      ];
    }

    // States.
    $form['states'] = [
      '#type' => 'details',
      '#title' => $this->t('States'),
      '#open' => TRUE,
      '#tree' => TRUE,
    ];

    $states = [
      "default", "hover", "active", "focus", "visited",
    ];

    foreach ($states as $key => $state) {
      $form['states'][$state] = [
        '#type' => 'checkbox',
        '#title' => $this->t(ucfirst($state)),
        '#default_value' => $active_states[$state] ?? 0,
      ];
    }

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->configFactory->getEditable('field_style.global_settings');

    $config->set('states', $form_state->getValue('states'));
    $config->set('properties', $form_state->getValue('properties'));
    $config->save();

    parent::submitForm($form, $form_state);
  }

}
