<?php

namespace Drupal\field_style\Utils;

/**
 * Google Fonts.
 */
class GoogleFonts {

  private $google_fonts = [];
  private $url = '';
  private $style = '';

  /**
   * Constructor.
   */
  public function __construct() {
    $config = \Drupal::config('field_style.settings');
    $this->google_fonts = $config->get('google_font_family') ?? [];
  }

  /**
   * Build Google Fonts URLs based on used fonts.
   */
  public function build($fonts_used = []) {
    $family_urls = [];

    $font_names = array_map(function ($font) {
        return str_replace(' ', '+', $font);
    }, array_keys($fonts_used));

    foreach ($this->google_fonts as $font) {

      if (preg_match('/[?&]family=([^:&]+)/', $font['name'], $matches)) {
        if (in_array($matches[1], $font_names)) {
          $family_urls[$matches[1]] = $font['name'];
        }
      }
    }

    return $family_urls;
  }

}
