# Field Style Drupal Module

## Overview

**Field Style** is a powerful Drupal module that enables site builders and editors to apply advanced CSS styling and responsive design directly to field outputs. It provides a flexible UI for configuring styles, breakpoints, custom fonts, and global styles, making it easy to create visually rich and responsive content without writing custom code. The module leverages a modern JavaScript/Vue.js application for its admin interface and supports both backend and frontend integration.

---

## Features

- **Field-Level Styling:** Apply custom CSS properties to individual fields using an intuitive UI.
- **Responsive Breakpoints:** Configure breakpoints for responsive design, allowing fields to adapt to different screen sizes.
- **Custom Fonts:** Upload and manage custom fonts, or select from Google Fonts for use in field styling.
- **Global Styles:** Define and manage global styles that can be reused across multiple fields and entities.
- **Advanced CSS Properties:** Supports a wide range of CSS properties, including animation, background, flexbox, grid, typography, and more.
- **Live Preview:** Instantly preview style changes in the admin interface.
- **Drag-and-Drop UI:** User-friendly interface for managing style properties, breakpoints, and fonts.
- **Twig Integration:** Custom templates for rendering styled fields on the frontend.
- **Extensible Architecture:** Easily add new style properties, components, or integrations.
- **API & Utils:** Backend utilities for font management, inline style generation, and Google Fonts integration.
- **Vue.js Admin App:** Modern SPA for managing all style settings, properties, and assets.

---

## Folder Structure

```
field_style/
├── .editorconfig
├── field_style.api.php
├── field_style.info.yml
├── field_style.install
├── field_style.libraries.yml
├── field_style.links.menu.yml
├── field_style.links.task.yml
├── field_style.module
├── field_style.routing.yml
├── field_style.schema.yml
├── LICENSE.txt
├── README.md
├── app/                       # Vue.js admin application
│   ├── .babelrc
│   ├── .eslint.json
│   ├── .eslintignore
│   ├── .gitignore
│   ├── .prettierignore
│   ├── .prettierrc
│   ├── .sass-lint.yml
│   ├── package.json
│   ├── webpack.config.js
│   ├── build/
│   │   ├── bundle.css
│   │   ├── bundle.js
│   │   └── *.svg
│   ├── src/
│   │   ├── App.vue
│   │   ├── event-bus.js
│   │   ├── functions.js
│   │   ├── index.html
│   │   ├── main.js
│   │   ├── routes.js
│   │   ├── settings.js
│   │   ├── components/
│   │   │   ├── dynamicProperty/
│   │   │   │   └── DynamicProperty.vue
│   │   │   ├── globalStyle/
│   │   │   │   └── globalStyle.vue
│   │   │   ├── property/
│   │   │   │   └── [many CSS property components]
│   │   │   ├── tabs/
│   │   │   └── upload/
│   │   ├── fonts/
│   │   ├── icons/
│   │   └── scss/
│   │       └── style.scss
├── css/
│   ├── form-settings.css
│   ├── style.css
│   └── style.css.map
├── icons/
│   └── icon-edit.svg
├── js/
│   └── main.js
├── src/
│   ├── FieldStyle.php
│   ├── Controller/
│   │   └── UploadController.php
│   ├── Element/
│   │   └── FieldStyleTextarea.php
│   ├── Form/
│   │   ├── FieldStyleBreakPointsForm.php
│   │   ├── FieldStyleCustomFontsForm.php
│   │   ├── FieldStyleForm.php
│   │   ├── FieldStyleGlobalStyleForm.php
│   │   ├── FieldStyleGoogleFontsForm.php
│   │   └── FieldStyleSettingsForm.php
│   ├── Plugin/
│   │   └── Field/
│   │       ├── FieldFormatter/
│   │       ├── FieldType/
│   │       └── FieldWidget/
│   ├── Utils/
│   │   ├── FieldStyleFonts.php
│   │   ├── GoogleFonts.php
│   │   └── InlineStyle.php
├── templates/
│   ├── field--field-style.html.twig
│   └── field-style.html.twig
```

---

## Main Functionalities

### 1. Field-Level Styling

- **FieldStyleForm.php:**  
  Provides a UI for selecting and configuring CSS properties for each field.
- **FieldStyleTextarea.php:**  
  Custom element for entering or previewing inline styles.

### 2. Responsive Breakpoints

- **FieldStyleBreakPointsForm.php:**  
  Configure breakpoints for responsive design, allowing fields to adapt to different devices.

### 3. Custom & Google Fonts

- **FieldStyleCustomFontsForm.php / FieldStyleGoogleFontsForm.php:**  
  Upload custom fonts or select from Google Fonts.  
- **Utils/FieldStyleFonts.php / Utils/GoogleFonts.php:**  
  Backend utilities for managing font assets and integration.

### 4. Global Styles

- **FieldStyleGlobalStyleForm.php:**  
  Define reusable global styles that can be applied to multiple fields or entities.
- **globalStyle.vue:**  
  Vue component for managing global styles.

### 5. Advanced CSS Properties

- **property/*.vue:**  
  Vue components for each supported CSS property (e.g., animation, background, flexbox, grid, typography, etc.).
- **DynamicProperty.vue:**  
  Dynamically loads and manages property components.

### 6. Live Preview & Drag-and-Drop UI

- **App.vue, main.js, event-bus.js:**  
  SPA architecture for instant preview and interactive management of styles.

### 7. Twig Integration

- **field--field-style.html.twig / field-style.html.twig:**  
  Custom templates for rendering styled fields on the frontend.

### 8. Extensible Architecture

- **Plugin/Field/FieldFormatter, FieldType, FieldWidget:**  
  Easily add new field formatters, types, or widgets for custom styling needs.

### 9. API & Utils

- **field_style.api.php:**  
  API documentation for developers.
- **Utils/InlineStyle.php:**  
  Generates inline CSS from configuration.

### 10. Upload Controller

- **UploadController.php:**  
  Handles font and asset uploads for use in styling.

---

## Usage

### Installation

1. Place the module in your `modules/custom` directory.
2. Install dependencies for the Vue.js app (if customizing the admin UI):
   ```bash
   cd app
   npm install
   npm run build
   ```
3. Enable the module via the Drupal admin interface or Drush:
   ```bash
   drush en field_style
   ```

### Configuring Field Styles

1. Go to the field style configuration page for your content type or field.
2. Use the UI to select CSS properties, set values, and preview changes.
3. Configure breakpoints for responsive design.
4. Upload custom fonts or select Google Fonts as needed.
5. Save your configuration; styles will be applied to field output.

### Applying Global Styles

- Define global styles in the global style form and apply them to fields or entities as needed.

### Extending

- Add new CSS property components in `app/src/components/property/`.
- Create new field formatters, types, or widgets in `src/Plugin/Field/`.
- Extend backend utilities for custom style logic.

---

## Requirements

- Drupal 9 or 10
- PHP 7.4+
- Node.js & npm (for building the Vue.js admin app, if customizing)
- Appropriate permissions to configure field styles

---

## License

See `LICENSE.txt`.

---

## Support

For issues or feature requests, open an issue in your repository or contact the maintainer.
