<?php

declare(strict_types=1);

namespace Drupal\Tests\field_translation_sync\Functional;

use Drupal\Tests\BrowserTestBase;
use PHPUnit\Framework\Attributes\Group;

/**
 * Test for TranslationSyncForm.
 */
#[Group('field_translation_sync')]
final class InstallTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'action',
    'content_translation',
    'field_translation_sync',
  ];

  /**
   * Test callback.
   */
  public function testTranslationSyncForm(): void {
    $admin_user = $this->drupalCreateUser(['use field translation sync']);
    $this->drupalLogin($admin_user);

    $this->drupalGet('/admin/content/field-translation-sync');
    $this->assertSession()->elementExists('xpath', '//h1[text() = "Are you sure you want to synchronize the translations for these (0) entities?"]');
  }

}
