<?php

namespace Drupal\field_value_tracker\Entity;

/**
 * Represents a field value tracker.
 */
interface FieldValueTrackerInterface {

  /**
   * Replace substring match with lower env value.
   *
   * @var string
   */
  public const string MODE_REPLACE = 'replace';

  /**
   * Completely overwrite all field values with lower env value.
   *
   * @var string
   */
  public const string MODE_OVERWRITE = 'overwrite';

  /**
   * Replace substring match with lower env value.
   *
   * @return bool
   *   Returns TRUE if the prod value should use substring replacement.
   */
  public function shouldReplace(): bool;

  /**
   * Completely overwrite all field values with lower env value.
   *
   * @return bool
   *   Returns TRUE if the prod value should be overwritten by the lower env
   *   value.
   */
  public function shouldOverwrite(): bool;

}
