<?php

namespace Drupal\field_value_tracker;

use Drupal\Component\Utility\Unicode;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Defines a class to build a listing of Field Value Tracker entities.
 */
class FieldValueTrackerListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['mode'] = $this->t('Mode');
    $header['target_field'] = $this->t('Field Target');
    $header['prod_value'] = $this->t('Production Value');
    $header['lower_env_value'] = $this->t('Lower Environment Value');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\field_value_tracker\Entity\FieldValueTracker $entity */
    $mode = $entity->get('mode')->value ?? 'replace';
    $row['mode'] = ucfirst($mode);

    $field_config = $entity->get('target_field')->entity;

    if ($field_config) {
      $field_id = $field_config->id();
      $field_label = $field_config->label();
      $row['target_field'] = [
        'data' => [
          '#markup' => $this->t('@label<br><small>@id</small>', [
            '@label' => $field_label,
            '@id' => $field_id,
          ]),
        ],
      ];
    }
    else {
      $row['target_field'] = $this->t('N/A');
    }

    $prod_value = $entity->get('prod_value')->value;
    $row['prod_value'] = [
      'data' => [
        '#plain_text' => $mode === 'overwrite' ? $this->t('N/A') : Unicode::truncate($prod_value ?? '', 50, FALSE, TRUE),
      ],
    ];
    $row['lower_env_value'] = [
      'data' => [
        '#plain_text' => Unicode::truncate($entity->get('lower_env_value')->value, 50, FALSE, TRUE),
      ],
    ];
    return $row + parent::buildRow($entity);
  }

}
