<?php

declare(strict_types=1);

namespace Drupal\file_extractor\Hook;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\file_extractor\Plugin\Field\ExtractedFileFieldItemList;

/**
 * Manipulates entity type information.
 */
class EntityTypeInfo {

  use StringTranslationTrait;

  /**
   * Implements hook_entity_base_field_info().
   */
  #[Hook('entity_base_field_info')]
  public function entityBaseFieldInfo(EntityTypeInterface $entity_type): array {
    $fields = [];
    if ($entity_type->id() != 'file') {
      return $fields;
    }

    $fields['file_extractor_extracted_file'] = BaseFieldDefinition::create('string_long')
      ->setLabel($this->t('File extractor: extracted file'))
      ->setDescription($this->t('The value obtained after extraction of this file.'))
      ->setComputed(TRUE)
      ->setClass(ExtractedFileFieldItemList::class)
      ->setTranslatable(FALSE);

    return $fields;
  }

}
