<?php

declare(strict_types=1);

namespace Drupal\Tests\file_extractor\Kernel\Extractor;

use Drupal\file_extractor\Plugin\file_extractor\Extractor\PdftotextExtractor;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the "Pdftotext" extractor.
 */
#[RunTestsInSeparateProcesses]
#[CoversClass(PdftotextExtractor::class)]
#[Group('file_extractor')]
class PdftotextExtractorTest extends ExtractorTestBase {

  /**
   * {@inheritdoc}
   */
  protected string $extractorPluginId = 'pdftotext_extractor';

  /**
   * {@inheritdoc}
   */
  protected array $extractorPluginConfiguration = [
    'pdftotext_path' => 'pdftotext',
  ];

}
