<?php

declare(strict_types=1);

namespace Drupal\Tests\file_extractor\Kernel\Extractor;

use Drupal\file_extractor\Plugin\file_extractor\Extractor\PythonPdf2txtExtractor;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the "Python Pdf2txt" extractor.
 */
#[RunTestsInSeparateProcesses]
#[CoversClass(PythonPdf2txtExtractor::class)]
#[Group('file_extractor')]
class PythonPdf2txtExtractorTest extends ExtractorTestBase {

  /**
   * {@inheritdoc}
   */
  protected string $extractorPluginId = 'python_pdf2txt_extractor';

  /**
   * {@inheritdoc}
   */
  protected array $extractorPluginConfiguration = [
    'python_path' => 'python3',
    'python_pdf2txt_script' => '/usr/bin/pdf2txt',
  ];

}
