<?php

declare(strict_types=1);

namespace Drupal\Tests\file_extractor\Kernel\Extractor;

use Drupal\file_extractor\Plugin\file_extractor\Extractor\TikaExtractor;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the "Tika" extractor.
 */
#[RunTestsInSeparateProcesses]
#[CoversClass(TikaExtractor::class)]
#[Group('file_extractor')]
class TikaExtractorTest extends ExtractorTestBase {

  public const string TIKA_APP_VERSION = '1.28.5';

  public const string TIKA_CONFIG_FILE_PATH = '/tmp/test-tika-config.xml';

  /**
   * {@inheritdoc}
   */
  protected string $extractorPluginId = 'tika_extractor';

  /**
   * {@inheritdoc}
   */
  protected array $extractorPluginConfiguration = [
    'java_path' => 'java',
    'tika_path' => '/var/apache-tika/tika-app-' . self::TIKA_APP_VERSION . '.jar',
    'tika_config_path' => self::TIKA_CONFIG_FILE_PATH,
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // cSpell:disable.
    // Generate Tika config file.
    $tika_config = '
      <properties>
        <service-loader initializableProblemHandler="ignore"/>
      </properties>
    ';
    // cSpell:enable.
    \file_put_contents(self::TIKA_CONFIG_FILE_PATH, $tika_config);
  }

}
