<?php

declare(strict_types=1);

namespace Drupal\Tests\file_extractor\Functional\Extractor;

use Drupal\file_extractor\Plugin\file_extractor\Extractor\TikaServerExtractor;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use Symfony\Component\Process\Process;

/**
 * Tests the "Tika server" extractor.
 *
 * Need to use functional tests for Tika server because of the need of an HTTP
 * client.
 */
#[CoversClass(TikaServerExtractor::class)]
#[Group('file_extractor')]
class TikaServerExtractorTest extends ExtractorTestBase {

  public const string TIKA_SERVER_VERSION = '1.28.5';

  /**
   * {@inheritdoc}
   */
  protected string $extractorPluginId = 'tika_server_extractor';

  /**
   * {@inheritdoc}
   */
  protected array $extractorPluginConfiguration = [
    'scheme' => 'http',
    'host' => 'localhost',
    'port' => TikaServerExtractor::TIKA_SERVER_DEFAULT_PORT,
    'timeout' => TikaServerExtractor::DEFAULT_TIMEOUT,
  ];

  /**
   * The process running the Tika server.
   *
   * @var \Symfony\Component\Process\Process
   */
  protected Process $process;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Launch Tika server in a dedicated process.
    $this->process = new Process([
      'java',
      '-jar',
      '/var/apache-tika/tika-server-' . self::TIKA_SERVER_VERSION . '.jar',
    ]);
    $this->process->start();
    // Need to ensure that the Tika server is started.
    \sleep(5);
  }

  /**
   * {@inheritdoc}
   */
  protected function tearDown(): void {
    $this->process->stop();
    parent::tearDown();
  }

}
