<?php

declare(strict_types=1);

namespace Drupal\Tests\file_extractor\Kernel\Extractor;

use Drupal\file_extractor\Plugin\file_extractor\Extractor\DocconvExtractor;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the "Docconv" extractor.
 */
#[RunTestsInSeparateProcesses]
#[CoversClass(DocconvExtractor::class)]
#[Group('file_extractor')]
class DocconvExtractorTest extends ExtractorTestBase {

  /**
   * {@inheritdoc}
   */
  protected string $extractorPluginId = 'docconv_extractor';

  /**
   * {@inheritdoc}
   */
  protected array $extractorPluginConfiguration = [
    'docconv_path' => '/usr/bin/docd',
  ];

}
