# File metadata PDF

A Drupal module providing a file metadata plugin to retrieve information from
PDFs.


## Features:

Uses a patched smalot/pdfparser to extract metadata from PDFs.


## Usage examples:

1. Use the _FileMetadataManagerInterface::class_ service to prepare collecting metadata for
   the pdf located at a desired URI:

  ```php
    $fmdm = \Drupal::service(FileMetadataManagerInterface::class);
    $my_pdf_metadata = $fmdm->uri('public::/path/to/your.pdf');
    ...
  ```

2. Get the value of a key:

  ```php
    ...
    $pdf_author = $my_pdf_metadata->getMetadata('pdf', 'Author');
    ...
  ```

3. Get an array with all the metadata values:

  ```php
    ...
    $my_pdf_info = [];
    foreach ($my_pdf_metadata->getSupportedKeys('pdf') as $key) {
      $my_pdf_info[$key] = $my_pdf_metadata->getMetadata('pdf', $key);
    }
    ...
  ```


## Common metadata keys:

Key                 |
--------------------|
Author              |
Title               |
(add more)          |
