# File metadata PDF

A Drupal module providing a file metadata plugin to retrieve information from
PDFs.


## Features:

Uses smalot/pdfparser to extract metadata from PDFs.

## Known issues:

On some pdfs smalot/pdfparser can run into memory issues when very large creating character
tables, and may need to be patched depending on the usage expectations, although this only 
affects certain pdfs so is potentially more of a project specific issue. 

## Usage examples:

1. Use the _FileMetadataManagerInterface::class_ service to prepare collecting metadata for
   the pdf located at a desired URI:

  ```php
    $fmdm = \Drupal::service(FileMetadataManagerInterface::class);
    $my_pdf_metadata = $fmdm->uri('public::/path/to/your.pdf');
    ...
  ```

2. Get the value of a key:

  ```php
    ...
    $pdf_author = $my_pdf_metadata->getMetadata('pdf', 'Author');
    ...
  ```

3. Get an array with all the metadata values:

  ```php
    ...
    $my_pdf_info = [];
    foreach ($my_pdf_metadata->getSupportedKeys('pdf') as $key) {
      $my_pdf_info[$key] = $my_pdf_metadata->getMetadata('pdf', $key);
    }
    ...
  ```


## Common metadata keys:

Key                 |
--------------------|
Author              |
Title               |
Producer            |
Subject             |
Keywords            |
Creator             |
Pages               |

Note that there may be many more 'extended' keys depending on authoring tools, or the purpose 
of the PDF. Once the pdf has been loaded by the metadata manager (as per the examples above) 
the getSupportedKeys('pdf') method will populate with all available keys for that specific 
pdf, so you can use that to determine exactly what keys are available.
