<?php

declare(strict_types=1);

namespace Drupal\file_visibility_track_usage\EventSubscriber;

use Drupal\Core\Config\ConfigCrudEvent;
use Drupal\Core\Config\ConfigEvents;
use Drupal\file_visibility\FileVisibilityPluginManager;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Listens to module's settings changes.
 */
class SettingsSubscriber implements EventSubscriberInterface {

  public function __construct(protected FileVisibilityPluginManager $manager) {}

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [ConfigEvents::SAVE => 'clearPluginManagerCache'];
  }

  /**
   * Clears plugin manager cache when the module settings are changing.
   *
   * @param \Drupal\Core\Config\ConfigCrudEvent $event
   *   The config CRUD event.
   */
  public function clearPluginManagerCache(ConfigCrudEvent $event): void {
    if ($event->getConfig()->getName() === 'file_visibility_track_usage.settings' && $event->isChanged('track_usage_config')) {
      $this->manager->clearCachedDefinitions();
    }
  }

}
