<?php

declare(strict_types=1);

namespace Drupal\file_visibility_track_usage;

use Drupal\Core\DependencyInjection\ServiceProviderInterface;
use Drupal\file_visibility_track_usage\DependencyInjection\EventSubscriberOrder;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Compiler\PassConfig;

/**
 * Add a compiler pass that alters the priorities for some event subscribers.
 */
class FileVisibilityTrackUsageServiceProvider implements ServiceProviderInterface {

  /**
   * {@inheritdoc}
   */
  public function register(ContainerBuilder $container): void {
    $container->addCompilerPass(new EventSubscriberOrder(), PassConfig::TYPE_AFTER_REMOVING, -100);
  }

}
