<?php

declare(strict_types=1);

namespace Drupal\file_visibility;

use Drupal\Core\Field\FieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

/**
 * Field item list class for the file's originalUri computed field.
 */
class FileOriginalUriFieldItemList extends FieldItemList {

  use ComputedItemListTrait;

  /**
   * {@inheritdoc}
   */
  protected function computeValue(): void {
    $uri = \Drupal::database()->select(FileVisibilityInterface::TABLE)
      ->fields(FileVisibilityInterface::TABLE, ['uri'])
      ->condition('fid', $this->getEntity()->id())
      ->execute()
      ->fetchField();
    if ($uri) {
      $this->list[0] = $this->createItem(0, $uri);
    }
  }

}
