<?php

declare(strict_types=1);

namespace Drupal\file_visibility\Form;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\TypedConfigManagerInterface;
use Drupal\Core\DependencyInjection\AutowireTrait;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\ConfigTarget;
use Drupal\Core\Form\FormStateInterface;
use Drupal\file_visibility\FileVisibilityPluginManager;

/**
 * The module's settings form.
 */
class FileVisibilitySettingsForm extends ConfigFormBase {

  use AutowireTrait;

  public function __construct(
    ConfigFactoryInterface $config_factory,
    TypedConfigManagerInterface $typedConfigManager,
    protected FileVisibilityPluginManager $manager,
  ) {
    parent::__construct($config_factory, $typedConfigManager);
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['enabled_plugins'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Enabled plugins'),
      '#description' => $this->t('If none is selected, all are used.'),
      '#options' => array_map(
        fn(array $definition) => $definition['label'],
        $this->manager->getDefinitions(),
      ),
      '#config_target' => new ConfigTarget(
        configName: 'file_visibility.settings',
        propertyPath: 'enabled_plugins',
        fromConfig: fn(?array $value): array => $value ?? [],
        toConfig: fn(array $value): array => array_keys(array_filter($value)),
      ),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['file_visibility.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'file_visibility_settings';
  }

}
