<?php

/**
 * @file
 * Hooks for the file_visibility module.
 */

declare(strict_types=1);

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Allows modules to alter the FileVisibility plugin definitions.
 *
 * @param array $info
 *   Array of plugin information exposed by hook page section plugins, altered
 *   by reference.
 *
 * @see \Drupal\file_visibility\FileVisibilityPluginManager
 * @see \Drupal\file_visibility\FileVisibilityPluginInterface
 */
function hook_file_visibility_info_alter(array &$info): void {
  $info['usage_track']['title'] = t('Simple relation');
}

/**
 * @} End of "addtogroup hooks".
 */
