<?php

declare(strict_types=1);

namespace Drupal\file_visibility\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an attribute for FileVisibility plugins discovery.
 *
 * Plugin Namespace: Plugin\FileVisibility.
 *
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class FileVisibility extends Plugin {

  /**
   * Constructs a new attribute instance.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the selection plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) The plugin description.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
  ) {}

}
