<?php

/**
 * @file
 * Provide views data and handlers for filehash table.
 */

/**
 * Implements hook_views_data().
 *
 * @phpstan-ignore-next-line Hook implementations should not duplicate @return
 * documentation.
 */
function filehash_views_data() {
  $data['filehash']['table']['group'] = t('File Hash');
  $data['filehash']['table']['join'] = [
    'file_managed' => [
      'left_field' => 'fid',
      'field' => 'fid',
    ],
  ];
  // Use a nice human-readable name for each hash algorithm.
  $names = filehash_names();
  foreach (filehash_columns() as $column) {
    $data['filehash'][$column] = [
      'title' => t('@algo hash', ['@algo' => $names[$column]]),
      'help' => t('The @algo hash of the file.', ['@algo' => $names[$column]]),
      'field' => [
        'id' => 'standard',
        'click sortable' => TRUE,
      ],
      'argument' => [
        'id' => 'string',
      ],
      'filter' => [
        'id' => 'string',
      ],
      'sort' => [
        'id' => 'standard',
      ],
    ];
    $data['filehash']["filehash_has_duplicate_$column"] = [
      'help' => t('Display file if at least one other file has the same @algo hash.', ['@algo' => $names[$column]]),
      'real field' => $column,
      'filter' => [
        'title' => t('Has duplicate @algo hash', ['@algo' => $names[$column]]),
        'id' => 'filehash_has_duplicate',
      ],
    ];
  }
  return $data;
}
