<?php

namespace Drupal\filehash\Plugin\views\filter;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Plugin\views\filter\FilterPluginBase;

/**
 * Filter handler for File Hash duplicate query.
 *
 * @ViewsFilter("filehash_has_duplicate")
 */
class HasDuplicate extends FilterPluginBase {

  /**
   * {@inheritdoc}
   */
  public $alwaysMultiple = TRUE;

  /**
   * {@inheritdoc}
   */
  // phpcs:ignore Drupal.NamingConventions.ValidVariableName.LowerCamelName
  public $no_operator = TRUE;

  /**
   * Display the filter on the administrative summary.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|string
   *   The label for this value.
   */
  public function adminSummary() {
    if (!empty($this->options['exposed'])) {
      return $this->t('exposed');
    }
    if (\is_string($this->value)) {
      return $this->valueOptions()[$this->value] ?? '';
    }
    return '';
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore missingType.iterableValue
   */
  protected function operatorForm(&$form, FormStateInterface $form_state): void {
    // @fixme Views markup has a stray </div> tag if operator element is
    // missing. @see https://www.drupal.org/project/drupal/issues/3547999
    $form['operator'] = [
      '#markup' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function query(): void {
    if (!$this->value) {
      return;
    }
    $this->ensureMyTable();
    // Method not defined on QueryPluginBase.
    if (method_exists($this->query, 'getConnection')) {
      $connection = $this->query->getConnection();
      $subquery = $connection->select('filehash', 'fh2')
        ->where("fh2.{$this->realField} = {$this->tableAlias}.{$this->realField}")
        ->range(1, 1);
      $subquery->addExpression('1');
      $operator = $this->value === 'no' ? 'NOT EXISTS' : 'EXISTS';
      // Method not defined on QueryPluginBase.
      if (method_exists($this->query, 'addWhere')) {
        $this->query->addWhere(0, '', $subquery, $operator);
      }
    }
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore missingType.iterableValue
   */
  protected function valueForm(&$form, FormStateInterface $form_state): void {
    $form['value'] = [
      '#type' => 'radios',
      '#title' => $this->t('Options'),
      '#options' => $this->valueOptions(),
      '#default_value' => $this->value,
    ];
  }

  /**
   * Provide value options.
   *
   * @return array<string, \Drupal\Core\StringTranslation\TranslatableMarkup>
   *   The array of options.
   */
  public function valueOptions(): array {
    return ['yes' => $this->t('Yes'), 'no' => $this->t('No')];
  }

}
