<?php

namespace Drupal\Tests\filehash\Functional;

use Drupal\file\Entity\File;
use Drupal\Tests\BrowserTestBase;
use Drupal\views\Views;

/**
 * Tests filter plugin functionality.
 */
class ViewsTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['views', 'filehash'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Tests query of the filter plugin.
   *
   * @covers \Drupal\filehash\Plugin\views\filter\HasDuplicate
   */
  public function testFilterQuery(): void {
    $user = $this->drupalCreateUser(['administer site configuration']);
    $this->assertNotFalse($user);
    $this->drupalLogin($user);
    $this->drupalGet('admin/config/media/filehash');
    $fields = ['algos[sha512_256]' => TRUE];
    $this->submitForm($fields, 'Save configuration');
    $this->rebuildContainer();
    $files = ['duck', 'duck', 'goose'];
    foreach ($files as $contents) {
      $uri = 'temporary://' . $this->randomMachineName() . '.txt';
      file_put_contents($uri, $contents);
      File::create([
        'uid' => $user->id(),
        'uri' => $uri,
        'status' => 0,
      ])->save();
    }
    $view = Views::getView('files');
    $this->assertNotNull($view);
    $view->setDisplay('page_1');
    $view->displayHandlers->get('default')->overrideOption('filters', [
      'filehash_has_duplicate_sha512_256' => [
        'id' => 'filehash_has_duplicate_sha512_256',
        'table' => 'filehash',
        'field' => 'filehash_has_duplicate_sha512_256',
        'value' => 'yes',
      ],
    ]);
    $view->execute();
    $this->assertCount(2, $view->result);
  }

}
