/**
 * @file
 * Entity Browser FilePond widget behavior.
 *
 * Registers EB-specific submit validator.
 */

(function (Drupal) {
  // Register EB validator: disable submit when no files selected.
  // Entity Browser requires at least one file to be uploaded.
  Drupal.filepond.addSubmitValidator(function (pond, form) {
    // Only apply to Entity Browser forms.
    if (!form.classList.contains('entity-browser-form')) {
      return false;
    }

    const files = pond.getFiles();
    return files.length === 0;
  });
})(Drupal);
