<?php

declare(strict_types=1);

namespace Drupal\filepond_test\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Test form with limited file uploads (max_files = 2).
 *
 * Used by FilePondMaxFilesTest to verify cardinality enforcement.
 */
class FilePondTestLimitedForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'filepond_test_limited_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['filepond'] = [
      '#type' => 'filepond',
      '#title' => $this->t('Upload (max 2 files)'),
      '#required' => FALSE,
      '#extensions' => 'jpg png gif bin',
      '#max_filesize' => '10M',
      '#max_files' => 2,
      '#upload_location' => 'public://filepond-test',
    ];

    $form['actions'] = [
      '#type' => 'actions',
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->messenger()->addStatus($this->t('Form submitted successfully.'));
  }

}
