# FilePond Crop

A FilePond submodule that adds image cropping functionality using Cropper.js v2
and Drupal's Crop API. Provides a cleaner alternative to `image_widget_crop`
for single-cardinality image fields.

**Important:** This widget only supports **single-cardinality image fields**
(fields configured to allow exactly 1 value). The widget will not appear as
an option for multi-value image fields. This limitation exists because the
cropping UI is designed for one image at a time - for galleries or multi-image
fields, use the standard FilePond Image widget.

## Features

- **Cropper.js v2** - Modern cropping interface with touch support
- **Non-destructive** - Stores crop coordinates, not modified files
- **Drupal Crop API** - Works with image styles that use focal point/crop effects
- **Circular crop mode** - For avatar-style cropping
- **Minimum width enforcement** - Prevent crops smaller than required
- **Two workflow modes** - Preview mode or direct mode

## Requirements

- FilePond module (parent)
- Crop module (`drupal/crop`)
- At least one crop type configured at `/admin/config/media/crop`
- **Single-cardinality image field** (cardinality = 1)

## Installation

```bash
drush en filepond_crop
```

The module uses **unpkg CDN** by default for Cropper.js, so no library
installation is required.

### Self-Hosting Cropper.js (Optional)

To host the library locally instead of using CDN:

1. Go to **Configuration > Media > FilePond** (`/admin/config/media/filepond`)
2. Under "FilePond Crop", uncheck "Load Cropper.js from CDN"
3. Install the library via Composer:

```bash
composer require npm-asset/cropperjs
```

This installs the library to `/libraries/cropperjs/`.

## Configuration

### 1. Create a Crop Type

First, create a crop type at `/admin/config/media/crop`:

- **Square crop** (1:1) - For avatars, thumbnails
- **Banner crop** (16:9) - For hero images
- **Portrait crop** (3:4) - For profile photos

### 2. Create an Image Style

Create an image style at `/admin/config/media/image-styles` that uses your
crop type:

1. Add effect: "Manual crop"
2. Select your crop type
3. Optionally add scale/resize effects after the crop

### 3. Configure the Field Widget

1. Go to **Manage form display** for your content type
2. Select "FilePond Image Crop" widget for your image field
3. Configure widget settings:

| Setting | Description |
|---------|-------------|
| **Crop type** | Which crop type to use (required) |
| **Cropper image style** | Image style for the cropper UI (performance) |
| **Show default crop** | Auto-apply centered crop on upload |
| **Show crop preview** | Enable Apply/Edit workflow vs direct mode |
| **Crop preview image style** | Image style for the preview thumbnail |
| **Circular crop** | Round selection for avatars (forces 1:1) |
| **Minimum crop width** | Minimum output width in pixels |
| **Show reset button** | Button to reset crop to default |

## Widget Modes

### Preview Mode (default)

When "Show crop preview" is enabled:

1. User uploads image
2. Cropper appears with selection
3. User clicks "Apply Crop"
4. Preview thumbnail shows the cropped result
5. User can click "Edit Crop" to adjust

### Direct Mode

When "Show crop preview" is disabled:

1. User uploads image
2. Cropper appears and stays visible
3. Crop coordinates save automatically on form submit
4. Simpler workflow, no Apply/Edit buttons

## Circular Crop Mode

Enable "Circular crop" for avatar fields:

- Forces 1:1 aspect ratio
- Shows circular selection overlay
- Preview displays as circle
- The actual crop is still square (CSS rounds it for display)

## Usage Tips

### Cropper Image Style

For large images, set a "Cropper image style" to scale down the image before
showing it in the cropper. This improves performance without affecting the
final crop (coordinates are scaled back to original dimensions).

Example: Create an image style that scales to max 1200px width.

### Minimum Width

Set "Minimum crop width" to prevent users from creating crops too small for
your design. For example, if your image style outputs 800px wide images,
set minimum to 800 to ensure quality.

### Aspect Ratio

The crop type's aspect ratio (if set) is automatically enforced in the
cropper. Users can resize but the ratio stays locked.

## Technical Details

### Coordinate Storage

Crop coordinates are stored in Crop entities linked to the file. The Crop
module's API handles:

- Saving coordinates (center-point based)
- Loading existing crops for editing
- Deleting crops when files are removed

### Image Style Integration

When you use an image style with a "Manual crop" effect:

1. The effect reads coordinates from the Crop entity
2. Applies the crop to generate the derivative
3. Subsequent effects (scale, etc.) work on the cropped image

### Coordinate Scaling

The widget handles coordinate scaling automatically:

- Cropper shows a scaled-down preview for performance
- Coordinates are converted to original file dimensions on save
- Existing crops are scaled back for display when editing

## Troubleshooting

### Crop not appearing in image style output

1. Verify the crop type matches between widget and image style
2. Check that a Crop entity exists for the file (inspect database)
3. Flush image style cache: `drush image:flush [style_name]`

### Cropper.js not loading

1. Check browser console for JavaScript errors
2. Verify CDN is accessible or local library is installed
3. Check status report at `/admin/reports/status` for library status

### Crop coordinates seem wrong

1. Ensure "Cropper image style" doesn't use crop effects (would pre-crop)
2. Check original image dimensions match what was uploaded
3. Try re-saving the crop

## Related Modules

- **Crop** (`drupal/crop`) - Provides the Crop API
- **Image Widget Crop** - Alternative with multi-crop support (more complex)
- **Focal Point** - Alternative approach using focal points instead of boxes
