jQuery(document).ready(function ($){
  $(document).on({
    ajaxSuccess: function (event, xhr, settings) {
      let response = JSON.parse(xhr.responseText);
      for (let i = 0; i < response.length; i++) {
        if (response[i].command !== undefined && (response[i].command === 'openDialog' || response[i].command === 'insert')) {
          if (response[i].data.includes('filerobot-widget-render')) {
            setTimeout(renderWidget, 1000);
          }
        }
      }
    }
  });

  let renderFilerobot = setInterval(renderWidget, 1000);

  function renderWidget() {
    (function ($) {
      if ($('.filerobot-widget-render').length > 0) {
        clearTimeout(renderFilerobot);
        let ScaleflexWidget = window.ScaleflexWidget;

        let scaleflexWidget = null;

        // Locale
        scaleflexWidget = ScaleflexWidget.Core({
          securityTemplateID: frSettings.SEC,
          container: frSettings.token,
        });

        // Plugins
        let Explorer = ScaleflexWidget.Explorer;
        let XHRUpload = ScaleflexWidget.XHRUpload;
        const ProgressPanel = ScaleflexWidget.ProgressPanel

        // Optional plugins:
        let ImageEditor = ScaleflexWidget.ImageEditor;
        // let Webcam = ScaleflexWidget.Webcam;

        const element = document.querySelector('.filerobot-widget-render'); // hoặc bất kỳ selector nào phù hợp

        const selectedWidgetClass = Array.from(element.classList).find(cls =>
          cls.startsWith('widget-selected-')
        );

        let limitTypeArray = [];
        limitTypeArray.push(selectedWidgetClass.replaceAll('widget-selected-', '').toUpperCase());

        scaleflexWidget
          .use(Explorer, {
            config: {
              rootFolderPath: frSettings.uploadDirectory
            },
            target: '.filerobot-widget-render',
            inline: true,
            width: "100%",
            height: "60vh",
            disableExportButton: false,
            hideExportButtonIcon: true,
            preventExportDefaultBehavior: true,
            dismissUrlPathQueryUpdate: true,
            disableDownloadButton: false,
            hideDownloadButtonIcon: true,
            preventDownloadDefaultBehavior: true,
            disabledFiltersAndSearch: false,
            showFoldersTree: false,
            ExploreViewComponent: ScaleflexWidget.Explorer.ExploreViewComponent,
            locale: {
              strings: {
                mutualizedExportButtonLabel: 'Insert',
                mutualizedDownloadButton: 'Insert'
              }
            },
            filters: {
              mimeTypes: limitTypeArray
            }
          })
          .use(ProgressPanel, {
            target: '#scaleflex-widget-progress-panel',
          })
          .use(XHRUpload)
          .use(ImageEditor)
          .on('export', async (files, popupExportSuccessMsgFn, downloadFilesPackagedFn, downloadFileFn) => {
            // console.dir(files);
            let frFooterButton = document.getElementsByClassName("SfxButton-root");
            for (let i = 0; i < frFooterButton.length; i++) {
              frFooterButton[i].setAttribute('disabled', 'true');
            }

            let textProcessing = 'Processing';
            let frExportButton = document.getElementsByClassName('filerobot-Explorer-TopBar-DownloadWithExportButton-downloadButton');
            let textExport;
            for (let i = 0; i < frExportButton.length; i++) {
              textExport = frExportButton[i].innerHTML;
              frExportButton[i].setAttribute('disabled', 'true');
              frExportButton[i].innerHTML = textProcessing;
            }

            let totalFiles = files.length;
            let index = 0;
            let mediaIds = [];
            for (const selected of files) {
              index++;
              let filerobotURL = selected.file.url.cdn;
              let newFilerobotUrl = new URL(filerobotURL);
              if (newFilerobotUrl.searchParams.has('vh')) {
                newFilerobotUrl.searchParams.delete('vh');
              }

              if (frSettings.CNAME !== '' && frSettings.CNAME !== null) {
                newFilerobotUrl.host = frSettings.CNAME;
                newFilerobotUrl.hostname = frSettings.CNAME;
              }

              fetch('/api/filerobot-insert-image', {
                method: 'POST',
                headers: {
                  'Content-Type': 'application/json',
                  'X-CSRF-Token': Drupal.csrfToken
                },
                body: JSON.stringify({
                  "uuid": selected.file.uuid,
                  "url": newFilerobotUrl.href,
                  "frFilename": selected.file.name,
                  "type": selected.file.type
                })
              })
                .then(response => {
                  if (!response.ok) {
                    throw new Error(response.statusText);
                  }
                  return response.json();
                })
                .then(data => {
                  let media_id = data.media_id;
                  let media_uuid = data.media_uuid;
                  if (!$('.filerobot-widget-render').hasClass('open-editor')) {
                    if (totalFiles === 1) {
                      $('input[data-media-library-widget-value="' + mediaFieldName + '"]').val(media_id);
                      $('input[data-media-library-widget-update="' + mediaFieldName + '"]').show();
                      $('input[data-media-library-widget-update="' + mediaFieldName + '"]').attr('onclick', 'updateWidget()');
                      $('.ui-dialog-titlebar-close').trigger('click');
                    } else {
                      mediaIds.push(media_id);
                      if (index === totalFiles) {
                        $('input[data-media-library-widget-value="' + mediaFieldName + '"]').val(mediaIds);
                        $('input[data-media-library-widget-update="' + mediaFieldName + '"]').show();
                        $('input[data-media-library-widget-update="' + mediaFieldName + '"]').attr('onclick', 'updateWidget()');
                        $('.ui-dialog-titlebar-close').trigger('click');
                      }
                    }
                  } else {
                    Drupal.CKEditor5Instances.get(activeCKEditor).model.change((writer) => {
                      const insertPosition = Drupal.CKEditor5Instances.get(activeCKEditor).model.document.selection.getFirstPosition();
                      let insertHtml = `<drupal-media data-entity-type="media" data-entity-uuid="${media_uuid}">&nbsp;</drupal-media>`;
                      writer.insert(insertHtml, insertPosition);

                      let newData = Drupal.CKEditor5Instances.get(activeCKEditor).getData();
                      newData = newData.replaceAll('&lt;', '<');
                      newData = newData.replaceAll('&gt;', '>');
                      Drupal.CKEditor5Instances.get(activeCKEditor).setData(newData);
                    });
                    $('.ui-dialog-titlebar-close').trigger('click');
                    activeCKEditor = null;
                  }
                })
                .catch(error => {
                  console.error(error);
                });
            }
          })
          .on('complete', ({failed, uploadID, successful}) => {
            if (failed) {
              console.dir(failed);
            }

            if (successful) {
              // console.dir(successful);
              successful.forEach((item, key) => {
                // do something
              });
            }
          });
      }
    })(jQuery);
  }
});

function updateWidget()
{
  jQuery('input[data-media-library-widget-update="field_media_image"]').hide();
}
