<?php

declare(strict_types = 1);

namespace Drupal\fillpdf_media\Hook;

use Drupal\Core\Form\FormState;
use Drupal\Core\Hook\Attribute\Hook;

class FormAlter {

  /**
   * Implements hook_form_FORM_ID_alter for FillPDF admin forms listing fillpdf-forms-admin.
   *
   * Remove adding of PDF upload form as people should go through media and it.
   */
  #[Hook('form_fillpdf_forms_admin_alter')]
  function formFillPdfFormsAdminAlter(&$form, FormState $form_state) {
    $form['upload_pdf']['#access'] = FALSE;
    $form['submit']['#access'] = FALSE;
  }

  /**
   * Implements hook_form_FORM_ID_alter for FillPDF Form Edit Form.
   */
  #[Hook('form_fillpdf_form_edit_form_alter')]
  function formFillPdfEditFormAlter(&$form, FormState $form_state) {
    $form['pdf_info']['upload_pdf']['#access'] = FALSE;
    $form['pdf_info']['upload_pdf_disabled']['#markup'] = '<p><small>' . t('Changing the uploaded PDF here is currently disabled so as to ensure the PDF media entity reference controls the relationship.  If this is problematic there is probably something we could do to sync uploads here back to the PDF entity.') . '</small></p>';
  }

}