<?php

namespace Drupal\fillpdf_media\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\Plugin\Field\FieldFormatter\EntityReferenceLabelFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Url;
use Drupal\file\Entity\File;
use Drupal\file\FileInterface;
use Drupal\media\MediaInterface;

/*
 * Plugin implementation of the 'fillpdf_file_url' formatter.
 *
 * Based on the 'file_url_plain' formatter.
 */
#[FieldFormatter(
  id: 'fillpdf_media_file_url',
  label: new TranslatableMarkup('URL to fillPDF for media'),
  field_types: [
    'entity_reference',
  ],
)]
class UrlFillPdfMediaFormatter extends EntityReferenceLabelFormatter {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($this->getEntitiesToView($items, $langcode) as $delta => $entity) {
      assert($entity instanceof MediaInterface);

      // @TODO do not hard code 'pdf'.
      if (isset($entity) && $entity->bundle() === 'pdf') {
        // Not sure there's a practical way to avoid hardcoding the field.
        $file_id = $entity->field_media_file->target_id;
        if ($file_id) {
          $fillpdf_admin_form_helper = \Drupal::service('fillpdf.admin_form_helper');
          $form_id = $fillpdf_admin_form_helper->getFormIdByFileId($file_id);
          if ($form_id) {
            $file_url = Url::fromRoute('fillpdf.populate_pdf')->toString() . '?fid=' . $form_id;
          }
          else {
            $file = File::load($file_id);
            $file_url = $file->createFileUrl() . '?note=sorry-no-form-filling-configured-for-this-pdf';
          }
        }
      }

      $elements[$delta] = [
        '#markup' => $file_url,
        '#cache' => [
          'tags' => $entity->getCacheTags(),
        ],
      ];
    }

    return $elements;
  }

  public static function isApplicable(FieldDefinitionInterface $field_definition) {
    return ($field_definition->getFieldStorageDefinition()->getSetting('target_type') == 'media');
  }

}
