<?php

namespace Drupal\fillpdf_media\Plugin\Menu\LocalAction;

use Drupal\Core\Menu\LocalActionDefault;
use Drupal\Core\Routing\RouteMatchInterface;

class FillPdfFormLocalAction extends LocalActionDefault {

  public function getRouteParameters(RouteMatchInterface $route_match) {
    /** @var \Drupal\fillpdf\Entity\FillPdfForm $fillPdfForm */
    $fillPdfForm = $route_match->getParameter('fillpdf_form');
    /** @var \Drupal\fillpdf_media\Service\MediaHelper $fillpdf_media_helper */
    $fillpdf_media_helper = \Drupal::service('fillpdf_media.helper');
    $media_id = $fillpdf_media_helper->getAssociatedMediaId($fillPdfForm);
    return [
      'media' => $media_id,
    ];
  }

  /**
   * Disable caching.
   *
   * Until we can do custom context or file, form, or media ID based tags.
   */
  public function getCacheMaxAge() {
    return 0;
  }

}