<?php

namespace Drupal\fillpdf_media\Plugin\Menu\LocalAction;

use Drupal\Core\Menu\LocalActionDefault;
use Drupal\Core\Routing\RouteMatchInterface;

class MediaLocalAction extends LocalActionDefault {

  public function getRouteParameters(RouteMatchInterface $route_match) {
    /** @var \Drupal\media\Entity\Media $media */
    $media = $route_match->getParameter('media');
    /** @var \Drupal\fillpdf_media\Service\MediaHelper $fillpdf_media_helper */
    $fillpdf_media_helper = \Drupal::service('fillpdf_media.helper');
    $form_id = $fillpdf_media_helper->getFillPdfFormId($media);
    return [
      'fillpdf_form' => $form_id,
    ];
  }

  // Not sure how to get the ID to pass into cache tags here, disabling caching for now
  // public function getCacheTags() {
  //  return ['fillpdf_form:' . $form_id];
  // }

  public function getCacheMaxAge() {
    return 0;
  }
}