<?php

namespace Drupal\fillpdf_media\Service;

use Drupal\fillpdf\FillPdfFormInterface;
use Drupal\media\MediaInterface;

/**
 * Various helper methods used in getting FillPDF information from PDF media.
 */
class MediaHelper {

  /**
   * Return the FillPDF form ID for the associated media.
   *
   * @var \Drupal\media\Entity\Media $media
   */
  public function getFillPdfFormId(MediaInterface $media) {
    $file_id = $media->getSource()->getSourceFieldValue($media);
    // $file_id = $media->get('field_media_file')->target_id ?? NULL;
    if (!$file_id) {
      return;
    }
    /** @var \Drupal\fillpdf\Service\FillPdfAdminFormHelper $fillpdf_admin_form_helper */
    $fillpdf_admin_form_helper = \Drupal::service('fillpdf.admin_form_helper');
    $form_id = $fillpdf_admin_form_helper->getFormIdByFileId($file_id);
    return $form_id;
  }

  /**
   * Return the media ID associated with the given FillPDF form.
   *
   * @var Drupal\fillpdf\Entity\FillPdfForm $fillPdfForm;
   */
  public function getAssociatedMediaId(FillPdfFormInterface $fillPdfForm) {
    /** @var \Drupal\fillpdf\Service\FillPdfAdminFormHelper $fillpdf_admin_form_helper */
    $fillpdf_admin_form_helper = \Drupal::service('fillpdf.admin_form_helper');
    $file_id = $fillpdf_admin_form_helper->getFileIdByFormId($fillPdfForm->id());

    $media_ids = \Drupal::entityQuery('media')
      ->condition('bundle', 'pdf')
      ->condition('field_media_file', $file_id)
      ->accessCheck(TRUE)
      ->execute();
    if ($media_ids) {
      if (count($media_ids) > 1) {
        // This is almost certainly pointless, if we wanted to check for 1:1
        // form ID to media ID it would be in FillPdfAdminFormHelper getFormIdByFileId() and
        \Drupal::logger('fillpdf_media')->warning(t('FillPDFForm %form_id is associated with file %file_id that is associated with multiple media entities: %media_ids', [
            '%form_id' => $fillPdfForm->id(),
            '%file_id' => $file_id,
            '%media_ids' => implode(',', $media_ids)
          ]));
      }
      $media_id = reset($media_ids);
      return $media_id;
    }
  }

}
