<?php

/**
 * @file
 * Drupal test bootstrap file.
 *
 * This file is used to set up the environment for running PHPUnit tests
 * for the first_time_login module.
 */

use Drupal\Component\Assertion\Handle;

// Ensure errors display during tests.
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

// Set the default timezone.
date_default_timezone_set('UTC');

// Find the Drupal root directory.
$drupal_root = dirname(dirname(__DIR__));
while (!file_exists($drupal_root . '/autoload.php') && !file_exists($drupal_root . '/vendor/autoload.php')) {
  $drupal_root = dirname($drupal_root);
  if ($drupal_root === '/') {
    throw new \Exception('Unable to locate Drupal root directory.');
  }
}

// Include Drupal's autoloader.
if (file_exists($drupal_root . '/autoload.php')) {
  $class_loader = require_once $drupal_root . '/autoload.php';
}
elseif (file_exists($drupal_root . '/vendor/autoload.php')) {
  $class_loader = require_once $drupal_root . '/vendor/autoload.php';
}

// Set up Drupal's assertion handler.
Handle::register();

// Define the module path for testing.
if (!defined('DRUPAL_TEST_IN_CHILD_SITE')) {
  define('DRUPAL_TEST_IN_CHILD_SITE', FALSE);
}

return $class_loader; 