<?php

namespace Drupal\Tests\first_time_login\Unit;

use Drupal\Tests\UnitTestCase;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Unit tests for First Time Login help functionality.
 *
 * @group first_time_login
 */
class FirstTimeLoginHelpTest extends UnitTestCase {

  /**
   * Tests the help hook with valid route.
   *
   * @covers ::first_time_login_help
   */
  public function testHelpWithValidRoute() {
    $route_match = $this->createMock(RouteMatchInterface::class);
    
    // Include the module file to access the hook function.
    require_once __DIR__ . '/../../../first_time_login.module';
    
    $help_output = first_time_login_help('help.page.first_time_login', $route_match);
    
    $this->assertIsString($help_output);
    $this->assertStringContainsString('About', $help_output);
    $this->assertStringContainsString('Super user (user with UID = 1)', $help_output);
    $this->assertStringContainsString('First time login module prompts user', $help_output);
    $this->assertStringContainsString('threshold number of days', $help_output);
    $this->assertStringContainsString('existing users will be updated', $help_output);
  }

  /**
   * Tests the help hook with invalid/unsupported route.
   *
   * @covers ::first_time_login_help
   */
  public function testHelpWithInvalidRoute() {
    $route_match = $this->createMock(RouteMatchInterface::class);
    
    // Include the module file to access the hook function.
    require_once __DIR__ . '/../../../first_time_login.module';
    
    $help_output = first_time_login_help('some.other.route', $route_match);
    
    $this->assertNull($help_output);
  }

  /**
   * Tests that help output is properly structured HTML.
   *
   * @covers ::first_time_login_help
   */
  public function testHelpOutputStructure() {
    $route_match = $this->createMock(RouteMatchInterface::class);
    
    // Include the module file to access the hook function.
    require_once __DIR__ . '/../../../first_time_login.module';
    
    $help_output = first_time_login_help('help.page.first_time_login', $route_match);
    
    // Check for proper HTML structure.
    $this->assertStringContainsString('<h3>', $help_output);
    $this->assertStringContainsString('</h3>', $help_output);
    $this->assertStringContainsString('<p>', $help_output);
    $this->assertStringContainsString('</p>', $help_output);
    $this->assertStringContainsString('<strong>', $help_output);
    $this->assertStringContainsString('</strong>', $help_output);
  }

} 