# First Time Login Module - Testing Documentation

This document provides information about the PHPUnit test suite for the First Time Login module.

## Test Structure

The test suite is organized into three types of tests following Drupal's testing standards:

### Unit Tests (`tests/src/Unit/`)
- **FirstTimeLoginSettingsTest.php**: Tests the settings form class in isolation
- **FirstTimeLoginHelpTest.php**: Tests the help hook functionality

### Kernel Tests (`tests/src/Kernel/`)
- **FirstTimeLoginHooksTest.php**: Tests module hooks with minimal Drupal bootstrap
- **FirstTimeLoginConfigTest.php**: Tests configuration management and edge cases

### Functional Tests (`tests/src/Functional/`)
- **FirstTimeLoginFunctionalTest.php**: Full browser testing of user interactions
- **FirstTimeLoginInstallTest.php**: Tests module installation and uninstallation

## Running Tests

### Prerequisites
- Drupal 8.x or 9.x installation
- PHPUnit (usually included with Drupal)
- Module installed in Drupal's modules directory

### Running All Tests
```bash
# From the Drupal root directory
./vendor/bin/phpunit modules/contrib/first_time_login/
```

### Running Specific Test Types
```bash
# Unit tests only
./vendor/bin/phpunit modules/contrib/first_time_login/tests/src/Unit/

# Kernel tests only
./vendor/bin/phpunit modules/contrib/first_time_login/tests/src/Kernel/

# Functional tests only
./vendor/bin/phpunit modules/contrib/first_time_login/tests/src/Functional/
```

### Running Individual Test Classes
```bash
# Specific test class
./vendor/bin/phpunit modules/contrib/first_time_login/tests/src/Unit/FirstTimeLoginSettingsTest.php
```

### Using Drupal's Test Runner
You can also use Drupal's built-in test runner:

```bash
# From Drupal root
php core/scripts/run-tests.sh --php `which php` --url http://your-drupal-site.local first_time_login
```

## Test Coverage

The test suite covers:

1. **Settings Form**:
   - Form building and validation
   - Configuration saving
   - Error handling

2. **Database Operations**:
   - User insertion tracking
   - Profile update handling
   - User deletion cleanup
   - Schema validation

3. **User Login Logic**:
   - First-time login detection
   - Redirect functionality
   - Message display
   - Super user exclusion
   - Time-based reminders

4. **Module Installation**:
   - Database table creation
   - Existing user migration
   - Configuration installation
   - Clean uninstallation

5. **Edge Cases**:
   - Zero days configuration
   - Large days configuration
   - Zero updated_date handling
   - Super user (uid=1) exclusion

## Test Group

All tests are tagged with the `@group first_time_login` annotation, allowing you to run all module tests with:

```bash
./vendor/bin/phpunit --group first_time_login
```

## Continuous Integration

These tests are designed to be compatible with Drupal.org's automated testing infrastructure and follow Drupal's coding standards for test contribution.

## Contributing

When adding new functionality to the module, please:

1. Add appropriate test coverage
2. Follow Drupal's testing conventions
3. Use meaningful test method names
4. Include proper documentation
5. Test both positive and negative scenarios

## Test Database

Functional and kernel tests will create temporary test databases. Ensure your test environment has appropriate database permissions.

For more information about Drupal testing, see:
- https://www.drupal.org/docs/automated-testing
- https://www.drupal.org/docs/automated-testing/phpunit-in-drupal 