<?php

/**
 * @file
 * Drupal test bootstrap file.
 *
 * This file is used to set up the environment for running PHPUnit tests
 * for the first_time_login module.
 */

// Ensure errors display during tests.
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

// Set the default timezone.
date_default_timezone_set('UTC');

// Get the current directory (module root).
$module_root = dirname(__DIR__);

// Look for autoloader in the vendor directory.
$autoloader_path = $module_root . '/vendor/autoload.php';

if (!file_exists($autoloader_path)) {
  throw new \Exception('Unable to locate autoloader at: ' . $autoloader_path);
}

// Include the autoloader.
$class_loader = require_once $autoloader_path;

// Set up assertion handling (new method for Drupal 10+).
assert_options(ASSERT_EXCEPTION, TRUE);

// Define the module path for testing.
if (!defined('DRUPAL_TEST_IN_CHILD_SITE')) {
  define('DRUPAL_TEST_IN_CHILD_SITE', FALSE);
}

return $class_loader; 