# Flagger Notify

Flagger Notify is a helper module that connects with the Flag module. It automatically sends email notifications to users when the content they have flagged is updated.

This module is designed to handle notifications in the background using Drupal's Queue API, which helps maintain site performance when sending emails to many users at once.

## Key Features

* **Background Processing**: Sends emails via Cron/Queue to avoid slowing down the site when saving content.
* **Batch Sending**: Processes emails in small groups (batches) to prevent server timeouts.
* **Duplicate Prevention**: Checks to ensure a user only receives one email per update, even if they used multiple flags on the same content.
* **Configurable**: You can choose which Flags trigger notifications.
* **Customizable Emails**: Allows administrators to change the email Subject and Body using tokens (supports HTML).
* **Language Support**: Groups notifications by language.

## Requirements

* PHP: >= 8.3
* Drupal Core: ^11
* Module: [Flag](https://www.drupal.org/project/flag) (^4.0)
* Module: [Token](https://www.drupal.org/project/token) (^1.0)

## Installation

Install via Composer (recommended):

```bash
composer require drupal/flagger_notify

```

Enable the module via Drush:

```bash
drush en flagger_notify

```

## Configuration

1. Go to **Administration > Configuration > System > Flagger Notify Settings**.
(Path: `/admin/config/system/flagger-notify`)
2. **General Settings**: Configure debug logging and retry behavior.
3. **Email Templates**: Set the default email Subject and Body. You can use standard tokens like `[node:title]` or `[user:display-name]`.
4. **Flag Settings**: Check the "Enable notifications" box for the specific flags you want to use.

## Troubleshooting

If emails are not sending:

1. Make sure **Cron** is running on your site.
2. Check **Reports > Recent log messages** (enable Debug Logging in the module settings first).
3. Ensure the subscriber has permission to view the flagged content.

## Maintainers

* Dao Duc Trung

## License

This project is licensed under the GNU General Public License, version 2 or later.

## Credits & Acknowledgments

*   **Author**: [Dao Duc Trung](https://github.com/daoductrung)
*   **Co-Pilot**: Code written and refined with the assistance of **Antigravity** (Google DeepMind).