# Flexus Default Pages Recipe

This recipe creates predefined Canvas pages when applied, using beautiful flexus theme Single Directory Components (SDCs). The pages include:

- **Homepage** (`/homepage`) - A stunning hero section with welcome content
- **Contact** (`/contact`) - Contact page with heading and text sections
- **About** (`/about`) - About page ready for your story
- **Privacy Policy** (`/privacy-policy`) - Privacy policy page template
- **Terms of Service** (`/terms-of-service`) - Terms of service page template

## Canvas Page Templates

This recipe also **enables Drupal Canvas for page templates** in the flexus theme and sets up an initial header configuration with:

- **Navbar component** (menu aligned to the right)
- **Site branding block** in the logo slot (left side)
- **Main navigation menu** in the navigation slot (right side)

The header configuration is defined in `config/canvas.page_region.flexus.header.yml` and will be automatically imported when the recipe is applied.

## Installation

Apply this recipe using one of the following methods:

### Using Drush (if available)
```bash
drush recipe web/themes/custom/flexus/recipes/default_pages
```

### Using Drupal Console
```bash
php web/core/scripts/drupal recipe web/themes/custom/flexus/recipes/default_pages
```

## Requirements

- Drupal Canvas module
- flexus theme (recommended for best experience, though pages will work with other themes)

## What Gets Created

The recipe will:
1. Ensure the Canvas module and path_alias module are installed
2. Enable Canvas for page templates in the flexus theme
3. Create the header PageRegion with navbar, branding, and main menu
4. Import all content from the `content/` directory, including:
   - Canvas pages (homepage, contact, about, privacy-policy, terms-of-service)
   - Media entities (images used in the pages)
   - File entities (image files)

## Post-Installation

No additional steps are required! The component versions are already configured in the recipe, following the same pattern as the navbar component in the header.

## Customization

After installation, you can:
1. Edit each page in the Canvas editor to add more components and customize the layout
2. Modify the page titles, descriptions, and content as needed
3. Add images, buttons, CTAs, and other flexus components
4. Delete any pages you don't need
5. Customize the header via `/admin/structure/canvas/page-regions` or through the Canvas UI

## Content Structure

The content is defined as YAML files in the `content/` directory, similar to how content is defined in Drupal recipes. This approach provides several benefits:

- **Version control friendly**: YAML files are easy to track in Git
- **Consistent with Drupal recipes**: Uses the same format as recipe content
- **Easy to modify**: Edit YAML files directly without PHP code
- **Reusable**: Can be exported/imported using Drupal's default content system
