<?php

namespace Drupal\flickr_integration_suite_field\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\flickr_integration_suite\FlickrIntegrationSuiteApiProvider;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Plugin implementation of the 'Flickr Photosets Slider' formatter.
 *
 * @FieldFormatter(
 *   id = "flickr_photosets_slider",
 *   label = @Translation("Flickr Photosets Slider"),
 *   field_types = {
 *     "flickr_photosets"
 *   }
 * )
 */
class FlickrPhotosetsSliderFormatter extends FormatterBase {

  /**
   * Flickr Integration Suite Api Provider.
   *
   * @var \Drupal\flickr_integration_suite\FlickrIntegrationSuiteApiProvider
   */
  protected $flickrIntegrationSuiteApiProvider;

  /**
   * Constructs a new FlickrPhotosetsSliderFormatter object.
   */
  public function __construct($plugin_id, $plugin_definition, FieldDefinitionInterface $field_definition, array $settings, $label, $view_mode, array $third_party_settings, FlickrIntegrationSuiteApiProvider $flickrIntegrationSuiteApiProvider) {
    parent::__construct($plugin_id, $plugin_definition, $field_definition, $settings, $label, $view_mode, $third_party_settings);
    $this->flickrIntegrationSuiteApiProvider = $flickrIntegrationSuiteApiProvider;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    return new static(
      $plugin_id,
      $plugin_definition,
      $configuration['field_definition'],
      $configuration['settings'],
      $configuration['label'],
      $configuration['view_mode'],
      $configuration['third_party_settings'],
      $container->get('flickr_integration_suite.api_provider')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $element = [];

    $per_page = $this->getFieldSetting('flickr_per_page');
    $page = $this->getFieldSetting('flickr_page');
    $media = $this->getFieldSetting('flickr_media');
    $extras = $this->getFieldSetting('flickr_extras');

    foreach ($items as $delta => $item) {
      $photoset_id = $item->value;
      $data = $this->flickrIntegrationSuiteApiProvider->photosetsGetPhotos($photoset_id, $per_page, $page, $media, $extras);

      $element[$delta] = [
        '#theme' => 'flickr_slider',
        '#data' => $data,
      ];
    }

    return $element;
  }

}
