<?php

/**
 * Implements hook_views_data_alter().
 *
 * Attach the FlipDown formatter to every Views field that represents a
 * datetime or timestamp column.  This makes “FlipDown countdown (FlipDown)”
 * appear in the *Formatter* list in Views UI.
 */
function flipdown_views_data_alter(array &$data) {
  foreach ($data as &$table) {
    foreach ($table as &$field) {
      // Only touch fields Views marks as "date" or "timestamp".
      if (!empty($field['type']) && in_array($field['type'], [
          'datetime',
          'timestamp',
        ])) {
        // Expose our handler as an available formatter.
        $field['field']['formatters']['flipdown_countdown'] = [
          'id' => 'flipdown_countdown',
          'label' => t('FlipDown countdown (FlipDown)'),
        ];
      }
    }
  }
}
