/**
 * FlipDown countdown behaviour (theme only; headings via Drupal.t()).
 */
(function (Drupal, drupalSettings, once) {

  Drupal.behaviors.flipdownCountdown = {
    attach: function (context) {
      const cfg = drupalSettings.flipdown || {};
      const targets = cfg.targets || {};
      const options = cfg.options || {};
      const endedText = cfg.endedText || 'Ended';

      Object.keys(targets).forEach(function (id) {
        // Ensure each element is initialised only once.
        const el = once('flipdown-countdown', '#' + id, context).shift();
        if (!el) {
          return;
        }

        const ts = targets[id];
        const opt = options[id] || {};
        const flipOpts = {
          theme: opt.color_theme || 'dark',
          headings: [
            Drupal.t('Days'),
            Drupal.t('Hours'),
            Drupal.t('Minutes'),
            Drupal.t('Seconds'),
          ],
        };

        if (ts) {
          new FlipDown(ts, id, flipOpts)
            .start()
            .ifEnded(() => {
              el.innerHTML = `<span class="flipdown-ended">${endedText}</span>`;
            });
        }
        else {
          el.innerHTML = `<span class="flipdown-ended">${endedText}</span>`;
        }
      });
    }
  };

})(Drupal, drupalSettings, once);
