### Flood Alerts England

Provides a block displaying current flood alerts for England from the Environment Agency Flood Monitoring API. Alerts can be filtered by county, flood area ID, or proximity (latitude/longitude with radius). The block is cached for 15 minutes.

---

### Features
- Block plugin: “Flood Alerts” (flood_alerts_england_block).
- Filter modes (selectable per block instance):
  - County (select list of counties/principal areas; alerts are for England only)
  - Flood area ID (floodAreaID)
  - Proximity search (lat, long, dist in km)
- Caching: 900 seconds

---

### Installation
Recommended (Composer):
1. Require the module:
   - `composer require drupal/flood_alerts_england`
2. Enable the module:
   - Admin UI: Extend → search “Flood Alerts England” → Enable, or
   - Drush: `drush en flood_alerts_england -y`
3. Clear caches: `drush cr`

---

### Add the block
1. Go to Structure → Block layout.
2. Choose a theme region and click “Place block”.
3. Search for “Flood Alerts” and click “Place block”.
4. Configure the block (see below) and save.

---

### Block configuration
- Filter method (radios):
  - County name
    - Field: County (select list; required in this mode)
  - Flood area ID
    - Field: Flood area ID (required in this mode)
  - Latitude/Longitude with radius
    - Fields: Latitude, Longitude, Radius (km) — all required in this mode

---

### Data source (API)
- Base endpoint used by the client: http://environment.data.gov.uk/flood-monitoring/id/floods
  - The module intentionally uses HTTP per the EA API behavior/documentation for this collection endpoint.
- Supported query parameters used by the block:
  - County mode: county=...
  - Flood area mode: floodAreaID=...
  - Proximity mode: lat=...&long=...&dist=...

---

### References
- EA Flood Monitoring API docs: https://environment.data.gov.uk/flood-monitoring/doc/reference
- Floods collection (used here): https://environment.data.gov.uk/flood-monitoring/id/floods
- GOV.UK target area page pattern: https://check-for-flooding.service.gov.uk/target-area/{floodAreaID}

---
