<?php

declare(strict_types=1);

namespace Drupal\flowdrop_node_type;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of flowdrop node types.
 */
final class FlowDropNodeTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header["id"] = $this->t("ID");
    $header["label"] = $this->t("Label");
    $header["category"] = $this->t("Category");
    $header["plugin_version"] = $this->t("Plugin Version");
    $header["enabled"] = $this->t("Enabled");
    $header["executor_plugin"] = $this->t("Executor Plugin");
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\flowdrop_node_type\FlowDropNodeTypeInterface $entity */
    $row["id"] = $entity->id();
    $row["label"] = $entity->label();
    $row["category"] = $this->t("@category", ["@category" => ucfirst($entity->getCategory())]);
    $row["plugin_version"] = $entity->getPluginVersion() ?: $this->t("N/A");
    $row["enabled"] = $entity->isEnabled() ? $this->t("Yes") : $this->t("No");
    $row["executor_plugin"] = $entity->getExecutorPlugin() ?: $this->t("None");
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultOperations(EntityInterface $entity): array {
    $operations = [];

    // Edit operation.
    $entityId = $entity->id();
    if (is_string($entityId)) {
      $operations["edit"] = [
        "title" => $this->t("Edit"),
        "url" => $entity->toUrl("edit-form"),
        "weight" => 10,
      ];

      // Delete operation.
      $operations["delete"] = [
        "title" => $this->t("Delete"),
        "url" => $entity->toUrl("delete-form"),
        "weight" => 100,
      ];
    }

    return $operations;
  }

}
