# FlowDrop UI Components

Provides reusable Single Directory Components (SDC) for the FlowDrop dashboard and administrative interfaces. Delivers a consistent visual language matching the FlowDrop workflow editor.

## Overview

This module provides:

- **Design Tokens**: CSS custom properties defining colors, typography, spacing, and other design primitives
- **Theme Layer**: Component-specific CSS variables that themes can override
- **SDC Components**: Reusable Twig components for building FlowDrop interfaces
- **Fullscreen Layout**: Immersive layout styles for dashboard pages

## Installation

```bash
drush en flowdrop_ui_components
```

## Icons

All components use **inline SVGs** for icons. This approach offers:

- ✅ No extra HTTP requests
- ✅ Styleable with CSS (`currentColor`)
- ✅ Perfect scaling at any size
- ✅ Works with Drupal's render system

### Passing Icons to Components

Pass SVG markup as a string to the `icon` prop:

```php
// In a controller
$icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="..."/></svg>';

$build['card'] = [
  '#type' => 'component',
  '#component' => 'flowdrop_ui_components:stat-card',
  '#props' => [
    'value' => '12',
    'label' => 'Workflows',
    'icon' => $icon,
  ],
];
```

Components render icons using `{{ icon|raw }}` to properly output the SVG.

### Brand Colors from Logo

The design tokens include colors from the [official FlowDrop logo](https://raw.githubusercontent.com/d34dman/flowdrop/refs/heads/1.x/static/logo.svg):

```css
--fd-brand-droplet: #009cde;      /* The water droplet */
--fd-brand-node-red: #f46351;     /* Center node */
--fd-brand-node-purple: #ccbaf4;  /* Left node */
--fd-brand-node-yellow: #ffc423;  /* Right node */
```

## Available Components

### FlowDrop Logo
The official FlowDrop logo component.

```twig
{{ include('flowdrop_ui_components:flowdrop-logo', {
  size: 'lg',
  show_background: false
}) }}
```

**Size options**: `sm` (24px), `md` (40px), `lg` (64px), `xl` (96px)

### Stat Card
Displays statistics with label, value, and optional icon.

```twig
{{ include('flowdrop_ui_components:stat-card', {
  value: '12',
  label: 'Workflows',
  icon: '<svg>...</svg>',
  variant: 'primary',
  url: '/admin/flowdrop/workflows'
}) }}
```

### Status Badge
Shows status indicators with dot animation support.

```twig
{{ include('flowdrop_ui_components:status-badge', {
  label: 'Active',
  variant: 'success',
  dot: true
}) }}
```

### Action Link
Clickable navigation cards for dashboard sections.

```twig
{{ include('flowdrop_ui_components:action-link', {
  title: 'Workflows',
  description: 'Manage workflow definitions',
  url: '/admin/flowdrop/workflows',
  icon: '<svg>...</svg>',
  badge: 12
}) }}
```

### Content Card
Rich cards for workflow/pipeline items.

```twig
{{ include('flowdrop_ui_components:content-card', {
  title: 'My Workflow',
  description: 'A sample workflow',
  url: '/admin/flowdrop/workflow/my-workflow',
  status: 'active',
  meta: ['4 nodes', '3 connections'],
  edited: '2 hours ago'
}) }}
```

### Page Header
Streamlined header with page title and action button.

```twig
{{ include('flowdrop_ui_components:page-header', {
  page_title: 'Dashboard',
  primary_action: {
    label: 'Create Workflow',
    url: '/admin/flowdrop/workflow/add'
  }
}) }}
```

### Search Toolbar
Search input with optional view toggle.

```twig
{{ include('flowdrop_ui_components:search-toolbar', {
  placeholder: 'Search workflows...',
  show_view_toggle: true,
  current_view: 'grid'
}) }}
```

### Button
Styled buttons with multiple variants.

```twig
{{ include('flowdrop_ui_components:button', {
  label: 'Save',
  variant: 'primary',
  icon: '<svg>...</svg>'
}) }}
```

## CSS Libraries

### design-tokens
Core design system tokens (colors, typography, spacing).

```yaml
dependencies:
  - flowdrop_ui_components/design-tokens
```

### theme-layer
Component-specific CSS variables for theming.

```yaml
dependencies:
  - flowdrop_ui_components/theme-layer
```

### fullscreen-layout
Immersive fullscreen layout with toolbar support.

```yaml
dependencies:
  - flowdrop_ui_components/fullscreen-layout
```

## Theming

### Customizing Colors

Create a custom CSS file in your theme and override the design tokens:

```css
:root {
  --fd-color-primary-500: #your-brand-color;
  --fd-color-accent-500: #your-accent-color;
}
```

### Component-Level Customization

Override component-specific variables in the theme layer:

```css
:root {
  --fd-button-primary-bg: #custom-color;
  --fd-card-radius: 16px;
}
```

## Layout Classes

### Grid Layouts

```html
<!-- Stats row -->
<div class="fd-stats-grid">...</div>

<!-- Cards grid -->
<div class="fd-cards-grid">...</div>

<!-- Action links -->
<div class="fd-actions-grid">...</div>
```

### Sections

```html
<section class="fd-section">
  <div class="fd-section__header">
    <h2 class="fd-section__title">Section Title</h2>
  </div>
  <!-- Content -->
</section>
```

### Toolbar

```html
<div class="fd-toolbar">
  <div class="fd-toolbar__start">
    <!-- Search -->
  </div>
  <div class="fd-toolbar__end">
    <!-- Actions -->
  </div>
</div>
```

## Development

Components are located in `components/` directory following the SDC specification:

```
components/
├── stat-card/
│   ├── stat-card.component.yml
│   ├── stat-card.twig
│   └── stat-card.css
├── status-badge/
│   └── ...
└── ...
```

Each component consists of:
- `*.component.yml`: Component definition and props schema
- `*.twig`: Twig template
- `*.css`: Component-specific styles

## Dependencies

This module has no dependencies and can be used standalone. It's designed to be the foundation for all FlowDrop administrative interfaces.

