# FlowDrop Module Dependency Graph

This document provides a visual representation of the FlowDrop module dependencies and relationships using Mermaid.js.

## Module Dependency Graph

The arrows indicate dependency direction: `A --> B` means "B depends on A".

> **Note**: This diagram shows only **direct dependencies**. Transitive dependencies (grandparent relationships) are omitted for clarity.

```mermaid
graph TD

    %% Base modules (no flowdrop dependencies)
    FD[flowdrop]
    FD_UI[flowdrop_ui]
    FD_NODE_CATEGORY[flowdrop_node_category]

    %% Core node type module
    FD_UI --> FD
    FD --> FD_NODE_TYPE[flowdrop_node_type]
    FD_NODE_CATEGORY --> FD_NODE_TYPE

    %% Node processor module
    FD_NODE_TYPE --> FD_NODE_PROCESSOR[flowdrop_node_processor]

    %% Workflow module
    FD_NODE_TYPE --> FD_WORKFLOW[flowdrop_workflow]

    %% Pipeline module
    FD_JOB[flowdrop_job]
    FD_JOB --> FD_PIPELINE[flowdrop_pipeline]
    FD_WORKFLOW --> FD_PIPELINE

    %% Runtime module
    FD_WORKFLOW --> FD_RUNTIME[flowdrop_runtime]
    FD_PIPELINE --> FD_RUNTIME

    %% Trigger Module
    FD_RUNTIME --> FD_TRIGGER[flowdrop_trigger]
    FD_WORKFLOW --> FD_TRIGGER

    %% Styling
    classDef baseModule fill:#c8e6c9,stroke:#2e7d32,stroke-width:2px
    classDef coreModule fill:#e1f5fe,stroke:#01579b,stroke-width:2px
    classDef uiModule fill:#e8f577,stroke:#1b5e20,stroke-width:2px
    classDef processingModule fill:#fff3e0,stroke:#e65100,stroke-width:2px
    classDef externalModule fill:#efefef,stroke:#2e2e2e,stroke-width:2px
    classDef processorPlugins fill:#e3f2fd,stroke:#1565c0,stroke-width:2px
    classDef ai fill:#f3e5f5,stroke:#7c3aed,stroke-width:2px

    class FD,FD_NODE_CATEGORY,FD_WORKFLOW baseModule
    class FD_NODE_TYPE coreModule
    class FD_UI uiModule
    class FD_PIPELINE,FD_JOB,FD_RUNTIME,FD_ITERATOR,FD_TRIGGER processingModule
    class FD_NODE_PROCESSOR processorPlugins
    class FD_ECA externalModule
    class FD_AI,FD_CONV,FD_AGENT ai
```

## Module Summary

| Module                    | Direct Dependencies         | Full Dependencies (info.yml)                                                         |
| ------------------------- | --------------------------- | ------------------------------------------------------------------------------------ |
| `flowdrop`                | (base module)               | —                                                                                    |
| `flowdrop_ui`             | (contrib module)            | —                                                                                    |
| `flowdrop_node_category`  | (base module)               | —                                                                                    |
| `flowdrop_job`            | (base module)               | drupal:options, drupal:text                                                          |
| `flowdrop_node_type`      | flowdrop, node_category     | flowdrop, flowdrop_node_category                                                     |
| `flowdrop_node_processor` | node_type                   | flowdrop, flowdrop_node_type                                                         |
| `flowdrop_workflow`       | node_type, ui               | flowdrop, flowdrop_node_type, flowdrop_node_category, flowdrop_ui                    |
| `flowdrop_pipeline`       | job, workflow               | flowdrop_job, flowdrop_workflow                                                      |
| `flowdrop_runtime`        | workflow, pipeline          | flowdrop, flowdrop_workflow, flowdrop_pipeline, flowdrop_job, flowdrop_node_type     |
| `flowdrop_trigger`        | runtime, workflow, pipeline | flowdrop, flowdrop_node_type, flowdrop_workflow, flowdrop_runtime, flowdrop_pipeline |
