# FlowDrop Node Type Module

The `flowdrop_node_type` module is a core component of the FlowDrop system that provides configurable node type definitions for workflow nodes. It serves as the foundation for creating, managing, and organizing different types of nodes that can be used in FlowDrop workflows.

## Goals

| Goal ID | Description |
|---------|-------------|
| FNT_G1 | Provide configurable node type definitions for workflow nodes |
| FNT_G2 | Enable site builders to create custom node types without coding |
| FNT_G3 | Provide categorization and organization of node types |

## Overview

The FlowDrop Node Type module provides:

- **Node Type Entity Management**: Config entity for storing node type definitions
- **Dynamic Configuration**: Schema-driven configuration forms for node types
- **Category Organization**: Categorization system for organizing node types
- **Plugin Integration**: Integration with node processor plugins

## Dependencies

The module depends on:

- `flowdrop` (main module)
- `flowdrop_node_category` (for node categorization)

## Entity Structure

### FlowDrop Node Type Entity

The node type entity is a configuration entity that stores node type definitions with the following properties:

#### **Core Properties**

- **`id`**: Unique identifier for the node type
- **`label`**: Human-readable name for the node type
- **`description`**: Detailed description of the node type functionality
- **`enabled`**: Whether the node type is enabled/disabled

#### **Visual Properties**

- **`category`**: Category for organizing node types (e.g., "processing", "input", "output")
- **`icon`**: Icon identifier for visual representation (e.g., "mdi:cog", "mdi:database")
- **`color`**: Color code for visual styling (e.g., "#007cba", "#ff6b6b")

## Choosing Icons

FlowDrop uses **[Material Design Icons (MDI)](https://pictogrammers.com/library/mdi/)** for node type icons. Icons are specified using the `mdi:` prefix followed by the icon name.

### Icon Format

```
mdi:<icon-name>
```

**Examples:**

- `mdi:cog` - Settings/configuration
- `mdi:database` - Data storage
- `mdi:robot` - AI/automation
- `mdi:code-tags` - Code/programming

### Finding Icons

1. **Browse the library**: Visit [pictogrammers.com/library/mdi](https://pictogrammers.com/library/mdi/)
2. **Search by keyword**: Use the search box to find icons by name or concept
3. **Copy the name**: Click an icon to see its name (e.g., "account-circle")
4. **Use in FlowDrop**: Prefix with `mdi:` (e.g., `mdi:account-circle`)

### Recommended Icons by Category

| Category | Recommended Icons |
|----------|-------------------|
| **Input/Output** | `mdi:import`, `mdi:export`, `mdi:keyboard`, `mdi:monitor`, `mdi:file-document` |
| **AI/Models** | `mdi:robot`, `mdi:brain`, `mdi:creation`, `mdi:head-cog`, `mdi:chat` |
| **Data Processing** | `mdi:cog`, `mdi:filter`, `mdi:swap-horizontal`, `mdi:merge`, `mdi:source-branch` |
| **Storage** | `mdi:database`, `mdi:folder`, `mdi:content-save`, `mdi:archive` |
| **Network/API** | `mdi:web`, `mdi:api`, `mdi:cloud`, `mdi:webhook`, `mdi:connection` |
| **Logic/Flow** | `mdi:call-split`, `mdi:source-fork`, `mdi:repeat`, `mdi:ray-start-arrow` |
| **Text** | `mdi:text`, `mdi:format-text`, `mdi:script-text`, `mdi:regex` |
| **Math** | `mdi:calculator`, `mdi:function`, `mdi:sigma`, `mdi:percent` |
| **Time** | `mdi:clock`, `mdi:timer`, `mdi:calendar`, `mdi:history` |
| **Utilities** | `mdi:tools`, `mdi:wrench`, `mdi:hammer`, `mdi:lightning-bolt` |

### Tips for Choosing Icons

1. **Be descriptive**: Choose icons that clearly represent the node's function
2. **Stay consistent**: Use similar icons for related node types
3. **Check visibility**: Ensure the icon is recognizable at small sizes (16-24px)
4. **Avoid confusion**: Don't use the same icon for different purposes

#### **Configuration Properties**

- **`version`**: Version string for the node type
- **`config`**: Configuration schema and default values
- **`tags`**: Array of tags for search and filtering
- **`executor_plugin`**: Plugin ID that handles node execution

## Admin Interface

### **Node Type Management Pages**

The module provides standard Drupal admin pages:

- **List**: `/admin/structure/flowdrop-node-type` - View all node types
- **Add**: `/admin/structure/flowdrop-node-type/add` - Create new node type
- **Edit**: `/admin/structure/flowdrop-node-type/{id}` - Edit node type
- **Delete**: `/admin/structure/flowdrop-node-type/{id}/delete` - Delete node type

### **Dynamic Configuration Forms**

The module provides dynamic configuration forms based on plugin schemas:

- **Schema-driven forms**: Automatically generated based on plugin configuration schemas
- **Validation**: Real-time validation of configuration values
- **AJAX updates**: Dynamic form updates based on configuration changes


## Services

### **FlowDropNodeTypeManager**

The main service for managing node types:
