<?php

namespace Drupal\flowdrop_trigger\Hook;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Session\AccountInterface;
use Drupal\flowdrop_trigger\Service\TriggerManager;
use Drupal\user\UserInterface;

/**
 * Implements user hooks for FlowDrop ecosystem.
 */
class UserHooks {

  /**
   * Constructs a new UserHooks object.
   */
  public function __construct(
    readonly protected TriggerManager $triggerEvent,
    readonly protected EntityTypeManagerInterface $entityTypeManager,
  ) {}

  /**
   * Implements hook_user_login().
   */
  #[Hook('user_login')]
  public function userLogin(UserInterface $account): void {
    $this->triggerEvent->processEvent('user.login', $account);
  }

  /**
   * Implements hook_user_logout().
   */
  #[Hook('user_logout')]
  public function userLogout(AccountInterface $account): void {
    $user = $this
      ->entityTypeManager
      ->getStorage('user')
      ->load($account->id());
    $this->triggerEvent->processEvent('user.logout', $user);
  }

  /**
   * Implements hook_user_cancel().
   */
  #[Hook('user_cancel')]
  public function userCancel(array $edit, UserInterface $account, string $method): void {
    $this->triggerEvent->processEvent('user.cancel', $account);
  }

}
