<?php

declare(strict_types=1);

namespace Drupal\flowdrop_trigger\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Ensures the combination of workflow_id and node_id is unique.
 *
 * @Constraint(
 *   id = "UniqueWorkflowNodeCombination",
 *   label = @Translation("Unique Workflow and Node combination", context = "Validation")
 * )
 */
class UniqueWorkflowNodeCombinationConstraint extends Constraint {

  /**
   * The violation message.
   *
   * @var string
   */
  public string $message = "The combination of workflow ID %workflow_id and node ID %node_id already exists.";

}
