<?php

declare(strict_types=1);

namespace Drupal\flowdrop\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Attribute for FlowDropNode plugins.
 *
 * This attribute provides plugin discovery metadata
 * for FlowDrop node processors.
 * Parameters are defined via getParameterSchema()
 * method, not in this attribute.
 * Category, tags, and visual type are managed by the config entity,
 * not by the plugin attribute.
 *
 * @see \Drupal\flowdrop\Plugin\FlowDropNodeProcessor\FlowDropNodeProcessorInterface::getParameterSchema()
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class FlowDropNodeProcessor extends Plugin {

  /**
   * Constructs a new FlowDropNode attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable label.
   * @param string $description
   *   The component description.
   * @param string $version
   *   The component version.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly string $description = "",
    public readonly string $version = "1.0.0",
    public readonly ?string $deriver = NULL,
  ) {}

}
